# Copyright (C) 2013-2021 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 25-Aug-2021 13:17.

"""astroClock userdefined profile, originally defined in resource file set
apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.datapoints.time_stamp
import izot.resources.properties.maxSendTime
import izot.resources.datapoints.switch
import P9000010600000000_4.properties.powerLine
import P9000010600000000_4.properties.offestSunrise
import P9000010600000000_4.properties.offestSunset


class astroClock(izot.resources.base.Profile):
    """astroClock userdefined profile.  """

    def __init__(self):
        super().__init__(
            key=20012,
            scope=4
        )
        self.datapoints['nvoLocalTime'] = izot.resources.base.Profile.DatapointMember(
            doc="""Time stamp.  """,
            name='nvoLocalTime',
            profile=self,
            number=1,
            datatype=izot.resources.datapoints.time_stamp.time_stamp,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoDusk'] = izot.resources.base.Profile.DatapointMember(
            doc="""Time stamp.  """,
            name='nvoDusk',
            profile=self,
            number=2,
            datatype=izot.resources.datapoints.time_stamp.time_stamp,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT,
            properties={
                'cpDuskDawnHb':
                izot.resources.base.Profile.PropertyMember(
                    doc="""Maximum send time.  The maximum period of time
                    between consecutive transmissions of the current
                    value.""",
                    name='cpDuskDawnHb',
                    profile=self,
                    number=2,
                    datatype=izot.resources.properties.maxSendTime.maxSendTime,
                    minimum=b'\x02\x58',
                    default=b'\x0b\xb8',
                    mandatory=True
                )
            }
        )
        self.datapoints['nvoDawn'] = izot.resources.base.Profile.DatapointMember(
            doc="""Time stamp.  """,
            name='nvoDawn',
            profile=self,
            number=3,
            datatype=izot.resources.datapoints.time_stamp.time_stamp,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoSunrise'] = izot.resources.base.Profile.DatapointMember(
            doc="""Time stamp.  """,
            name='nvoSunrise',
            profile=self,
            number=4,
            datatype=izot.resources.datapoints.time_stamp.time_stamp,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoSunset'] = izot.resources.base.Profile.DatapointMember(
            doc="""Time stamp.  """,
            name='nvoSunset',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.time_stamp.time_stamp,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoAfterDark'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch ON means the sun has set for dirrect control.""",
            name='nvoAfterDark',
            profile=self,
            number=6,
            datatype=izot.resources.datapoints.switch.switch,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.properties['cpTimeHb'] = izot.resources.base.Profile.PropertyMember(
            doc="""Maximum send time.  The maximum period of time between
            consecutive transmissions of the current value.""",
            name='cpTimeHb',
            profile=self,
            number=1,
            datatype=izot.resources.properties.maxSendTime.maxSendTime,
            minimum=b'\x02\x58',
            maximum=b'\x0b\xb8',
            default=b'\x0b\xb8',
            mandatory=True
        )
        self.properties['cpPowerline'] = izot.resources.base.Profile.PropertyMember(
            doc=""" Set to 1 to throttle channel updates for PL channel.""",
            name='cpPowerline',
            profile=self,
            number=3,
            datatype=P9000010600000000_4.properties.powerLine.powerLine,
            default=b'\x01',
            mandatory=True
        )
        self.properties['cpDawnAdjust'] = izot.resources.base.Profile.PropertyMember(
            doc=""" Adjust sunrise for local conditons.""",
            name='cpDawnAdjust',
            profile=self,
            number=4,
            datatype=P9000010600000000_4.properties.offestSunrise.offestSunrise,
            default=b'\x00',
            mandatory=True
        )
        self.properties['cpDuskAdjust'] = izot.resources.base.Profile.PropertyMember(
            doc=""" Adjust sunset for local conditions.""",
            name='cpDuskAdjust',
            profile=self,
            number=5,
            datatype=P9000010600000000_4.properties.offestSunset.offestSunset,
            default=b'\x00',
            mandatory=True
        )
        self._original_name = 'UFPTastroClock'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = astroClock()
    pass
